/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.rotation;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record CustomRotation(float x, float y, float z, boolean locked) {
    public static final CustomRotation DEFAULT = new CustomRotation(0.0f, 0.0f, 0.0f, false);
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomRotation> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CustomRotation>(){

        public CustomRotation decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new CustomRotation(registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), false);
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, CustomRotation rotation) {
            registryFriendlyByteBuf.writeFloat(rotation.x);
            registryFriendlyByteBuf.writeFloat(rotation.y);
            registryFriendlyByteBuf.writeFloat(rotation.z);
            registryFriendlyByteBuf.writeBoolean(rotation.locked);
        }
    };

    public CustomRotation(float x, float y, float z) {
        this(x, y, z, false);
    }

    public CustomRotation(ModelPartType modelPartType, CompoundTag compoundTag) {
        this(compoundTag.getList(modelPartType.getTagName(), 5));
    }

    public CustomRotation(ListTag listTag) {
        this(listTag != null && listTag.size() > 0 ? listTag.getFloat(0) : 0.0f, listTag != null && listTag.size() > 1 ? listTag.getFloat(1) : 0.0f, listTag != null && listTag.size() > 2 ? listTag.getFloat(2) : 0.0f, listTag != null && listTag.size() > 3 && listTag.getFloat(3) == 1.0f);
    }

    public CustomRotation(List<Float> list) {
        this(list != null && list.size() > 0 ? list.get(0).floatValue() : 0.0f, list != null && list.size() > 1 ? list.get(1).floatValue() : 0.0f, list != null && list.size() > 2 ? list.get(2).floatValue() : 0.0f, list != null && list.size() > 3 && list.get(3).floatValue() == 1.0f);
    }

    public CustomRotation withLocked(boolean locked) {
        return new CustomRotation(this.x, this.y, this.z, locked);
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)this.x));
        listTag.add((Object)FloatTag.valueOf((float)this.y));
        listTag.add((Object)FloatTag.valueOf((float)this.z));
        listTag.add((Object)FloatTag.valueOf((float)(this.locked ? 1.0f : 0.0f)));
        return listTag;
    }

    public boolean hasChanged() {
        return this.hasChanged(0.0f, 0.0f, 0.0f);
    }

    public boolean hasChangedYaw() {
        return this.x == 0.0f && this.y != 0.0f && this.z == 0.0f && this.locked;
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.hasChanged(x, y, z, false);
    }

    public boolean hasChanged(float x, float y, float z, boolean locked) {
        return this.x != x || this.y != y || this.z != z || this.locked != locked;
    }
}

