/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.display;

import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record DisplayAttributeEntry(boolean booleanValue, int intValue, String stringValue) {
    public static final String DATA_BOOLEAN_VALUE_TAG = "Bool";
    public static final String DATA_INT_VALUE_TAG = "Int";
    public static final String DATA_STRING_VALUE_TAG = "Text";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DisplayAttributeEntry(boolean booleanValue) {
        this(booleanValue, 0, "");
    }

    public DisplayAttributeEntry(int intValue) {
        this(false, intValue, "");
    }

    public DisplayAttributeEntry(String stringValue) {
        this(false, 0, stringValue);
    }

    public DisplayAttributeEntry(CompoundTag compoundTag) {
        this(compoundTag.contains(DATA_BOOLEAN_VALUE_TAG) && compoundTag.getBoolean(DATA_BOOLEAN_VALUE_TAG), compoundTag.contains(DATA_INT_VALUE_TAG) ? compoundTag.getInt(DATA_INT_VALUE_TAG) : 0, compoundTag.contains(DATA_STRING_VALUE_TAG) ? compoundTag.getString(DATA_STRING_VALUE_TAG) : "");
    }

    public DisplayAttributeEntry create(CompoundTag compoundTag) {
        return new DisplayAttributeEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        if (this.booleanValue) {
            compoundTag.putBoolean(DATA_BOOLEAN_VALUE_TAG, true);
        }
        if (this.intValue != 0) {
            compoundTag.putInt(DATA_INT_VALUE_TAG, this.intValue);
        }
        if (this.stringValue != null && !this.stringValue.isEmpty()) {
            compoundTag.putString(DATA_STRING_VALUE_TAG, this.stringValue);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    @Override
    public String toString() {
        return "DisplayAttributeEntry{boolean=" + this.booleanValue + ", int=" + this.intValue + ", string=" + this.stringValue + "}";
    }
}

