/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.EasyNPCModelManager;
import de.markusbordihn.easynpc.client.model.armpose.ModelArmPoseUtils;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;

public class EasyNPCModel {
    public static boolean setupAnimationStart(EasyNPC<?> easyNPC, EasyNPCModelManager modelManager) {
        if (easyNPC == null || modelManager == null) {
            return false;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            return false;
        }
        return EasyNPCModel.setupAnimation(easyNPC, modelData, modelManager);
    }

    public static boolean setupAnimation(EasyNPC<?> easyNPC, ModelDataCapable<?> modelData, EasyNPCModelManager modelManager) {
        if (easyNPC == null || modelData == null || modelManager == null) {
            return false;
        }
        modelManager.resetModelParts();
        if (modelData.getModelPose() == ModelPose.DEFAULT) {
            return false;
        }
        return modelManager.setupModelParts(modelData);
    }

    public static int getEntityLightLevel(EasyNPC<?> easyNPC, DisplayAttributeDataCapable<?> displayAttributeData, BlockPos blockPos) {
        if (easyNPC == null || displayAttributeData == null || blockPos == null) {
            return 0;
        }
        int entityLightLevel = displayAttributeData.getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
        if (entityLightLevel > 0) {
            return entityLightLevel;
        }
        return easyNPC.getLivingEntity().level().getBrightness(LightLayer.BLOCK, blockPos);
    }

    public static void renderEntityNameTag(EasyNPC<?> easyNPC, ModelDataCapable<?> modelData, PoseStack poseStack) {
        if (easyNPC == null || modelData == null) {
            return;
        }
        CustomRotation rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        if (rootRotation != null) {
            poseStack.translate(0.0f, 1.0f, 0.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(-rootRotation.x()));
            poseStack.mulPose(Axis.YP.rotationDegrees(-rootRotation.y()));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-rootRotation.z()));
            poseStack.translate(0.0f, -1.0f, 0.0f);
        }
    }

    public static void setupAnimationEnd(EasyNPC<?> easyNPC, EasyNPCModelManager modelManager) {
        if (easyNPC == null || modelManager == null) {
            return;
        }
        EasyNPCModel.setupArmPoses(easyNPC, modelManager);
    }

    public static void setupArmPoses(EasyNPC<?> easyNPC, EasyNPCModelManager modelManager) {
        ModelArmPose leftArmPose;
        if (easyNPC == null || modelManager == null) {
            return;
        }
        ModelArmPose rightArmPose = ModelArmPoseUtils.getArmPoseForRightArm(easyNPC);
        if (rightArmPose != null && rightArmPose != ModelArmPose.DEFAULT) {
            EasyNPCModel.applyArmPoseToModelPart(rightArmPose, modelManager.getModelPart(ModelPartType.RIGHT_ARM), true, modelManager.getModelPart(ModelPartType.HEAD), easyNPC);
        }
        if ((leftArmPose = ModelArmPoseUtils.getArmPoseForLeftArm(easyNPC)) != null && leftArmPose != ModelArmPose.DEFAULT) {
            EasyNPCModel.applyArmPoseToModelPart(leftArmPose, modelManager.getModelPart(ModelPartType.LEFT_ARM), false, modelManager.getModelPart(ModelPartType.HEAD), easyNPC);
        }
    }

    public static void applyArmPoseToModelPart(ModelArmPose armPose, ModelPart armModelPart, boolean isRightArm, ModelPart head, EasyNPC<?> easyNPC) {
        if (armPose == null || armModelPart == null) {
            return;
        }
        switch (armPose) {
            case BOW_AND_ARROW: {
                armModelPart.yRot = isRightArm ? -0.1f + (head != null ? head.yRot : 0.0f) : 0.1f + (head != null ? head.yRot : 0.0f) + 0.4f;
                armModelPart.xRot = -1.5707964f + (head != null ? head.xRot : 0.0f);
                break;
            }
            case CROSSBOW_HOLD: {
                if (isRightArm) {
                    armModelPart.yRot = -0.3f + (head != null ? head.yRot : 0.0f);
                    armModelPart.xRot = -1.5707964f + (head != null ? head.xRot : 0.0f) + 0.1f;
                    break;
                }
                armModelPart.yRot = 0.6f + (head != null ? head.yRot : 0.0f);
                armModelPart.xRot = -1.5f + (head != null ? head.xRot : 0.0f);
                break;
            }
            case CROSSBOW_CHARGE: {
                if (isRightArm) {
                    armModelPart.yRot = -0.8f;
                    armModelPart.xRot = -0.97079635f;
                    break;
                }
                armModelPart.yRot = 0.85f;
                armModelPart.xRot = -1.5707964f;
                break;
            }
            case SPYGLASS: {
                armModelPart.xRot = Mth.clamp((float)armModelPart.xRot, (float)-1.2f, (float)1.2f) - 1.9198622f;
                armModelPart.yRot = isRightArm ? 0.5235988f : -0.5235988f;
                break;
            }
            case ATTACKING_WITH_MELEE_WEAPON: {
                float swingProgress = 0.0f;
                if (easyNPC != null && easyNPC.getLivingEntity() != null) {
                    LivingEntity livingEntity = easyNPC.getLivingEntity();
                    if (livingEntity.swinging) {
                        swingProgress = Mth.clamp((float)((float)livingEntity.swingTime / 6.0f), (float)0.0f, (float)1.0f);
                        swingProgress = Mth.sin((float)(swingProgress * (float)Math.PI));
                    }
                }
                armModelPart.xRot = swingProgress * -1.8f - 0.3f;
                armModelPart.yRot = isRightArm ? -0.3f : 0.3f;
                armModelPart.zRot = swingProgress * (isRightArm ? -0.5f : 0.5f);
                break;
            }
            case SPELLCASTING: {
                armModelPart.xRot = armModelPart.xRot * 0.5f - (float)Math.PI;
                armModelPart.yRot = 0.0f;
                break;
            }
            case GUN_HOLD: {
                if (isRightArm) {
                    armModelPart.yRot = -0.2f + (head != null ? head.yRot : 0.0f);
                    armModelPart.xRot = -1.5707964f + (head != null ? head.xRot : 0.0f);
                    break;
                }
                armModelPart.yRot = 0.4f + (head != null ? head.yRot : 0.0f);
                armModelPart.xRot = -1.3f + (head != null ? head.xRot : 0.0f);
                break;
            }
            case ATTACKING: {
                float attackRotation = 0.8f;
                armModelPart.xRot = attackRotation * -0.8f;
                armModelPart.yRot = isRightArm ? -0.2f : 0.2f;
                break;
            }
            case CELEBRATING: {
                armModelPart.xRot = -0.5f;
                armModelPart.yRot = isRightArm ? -0.3f : 0.3f;
                armModelPart.zRot = isRightArm ? 0.3f : -0.3f;
                break;
            }
            case DANCING: {
                float danceRotation;
                armModelPart.xRot = danceRotation = Mth.sin((float)((float)System.currentTimeMillis() * 0.001f)) * 0.3f;
                armModelPart.yRot = isRightArm ? -0.2f : 0.2f;
                armModelPart.zRot = isRightArm ? danceRotation * 0.5f : -danceRotation * 0.5f;
                break;
            }
            case CROSSED: {
                if (isRightArm) {
                    armModelPart.xRot = -0.8f;
                    armModelPart.yRot = 0.6f;
                    break;
                }
                armModelPart.xRot = -0.8f;
                armModelPart.yRot = -0.6f;
                break;
            }
            case NEUTRAL: {
                armModelPart.xRot = 0.0f;
                armModelPart.yRot = 0.0f;
                armModelPart.zRot = 0.0f;
                break;
            }
        }
    }
}

