/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import mob_grinding_utils.tile.TileEntitySinkTank;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;

public class EntityXPOrbFalling
extends ExperienceOrb {
    private int age;
    public int delayBeforeCanPickup;

    public EntityXPOrbFalling(Level level, double x, double y, double z, int expValue) {
        super(EntityType.EXPERIENCE_ORB, level);
        this.setPos(x, y, z);
        this.setYRot((float)(Math.random() * 360.0));
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.value = expValue;
    }

    public void tick() {
        super.tick();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        ++this.tickCount;
        ++this.age;
        if (this.age >= 6000) {
            this.removeAfterChangingDimensions();
        }
    }

    public void playerTouch(@Nonnull Player player) {
        if (!this.level().isClientSide && this.delayBeforeCanPickup == 0 && player.takeXpDelay == 0) {
            ItemStack itemstack;
            if (((PlayerXpEvent.PickupXp)NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.PickupXp(player, (ExperienceOrb)this))).isCanceled()) {
                return;
            }
            player.takeXpDelay = 2;
            player.take((Entity)this, 1);
            Optional entry = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)player, ItemStack::isDamaged);
            if (entry.isPresent() && !(itemstack = ((EnchantedItemInUse)entry.get()).itemStack()).isEmpty() && itemstack.isDamaged()) {
                int i = Math.min((int)((float)this.value * itemstack.getXpRepairRatio()), itemstack.getDamageValue());
                this.value -= this.durabilityToXp(i);
                itemstack.setDamageValue(itemstack.getDamageValue() - i);
            }
            if (this.value > 0) {
                TileEntitySinkTank.addPlayerXP(player, this.value);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private int durabilityToXp(int durability) {
        return durability / 2;
    }

    private int xpToDurability(int xp) {
        return xp * 2;
    }
}

