/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModTags;
import mob_grinding_utils.blocks.BlockDirtSpawner;
import mob_grinding_utils.events.DirtSpawnEvent;
import mob_grinding_utils.network.MGUClientPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;

public class BlockDelightfulDirt
extends BlockDirtSpawner {
    public BlockDelightfulDirt(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean shouldSnowCap(LevelAccessor level, BlockPos pos) {
        return level.canSeeSkyFromBelowWater(pos) && level.dayTime() >= 13000L && level.dayTime() <= 23000L;
    }

    public boolean shouldSpawnMob(LevelAccessor level, BlockPos pos) {
        return level.getMaxLocalRawBrightness(pos.above()) >= 10 && level.getBlockState(pos.above()).isAir();
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        if (this.shouldSnowCap((LevelAccessor)level, pos) || this.shouldSpawnMob((LevelAccessor)level, pos)) {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.random, (int)20, (int)60));
        }
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (this.shouldSnowCap(level, pos) || this.shouldSpawnMob(level, pos)) {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)20, (int)60));
        }
        return super.updateShape(stateIn, facing, facingState, level, pos, facingPos);
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (this.shouldSnowCap((LevelAccessor)level, pos) || this.shouldSpawnMob((LevelAccessor)level, pos)) {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.random, (int)20, (int)60));
        }
    }

    public void randomTick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (this.shouldSnowCap((LevelAccessor)level, pos)) {
            BlockPos posUp = pos.above();
            BlockState blockstate = Blocks.SNOW.defaultBlockState();
            if (level.getBlockState(posUp).isAir() && blockstate.canSurvive((LevelReader)level, posUp)) {
                level.setBlock(posUp, blockstate, 11);
            }
        }
        if (!this.shouldSnowCap((LevelAccessor)level, pos) && this.shouldSpawnMob((LevelAccessor)level, pos)) {
            BlockPos posUp;
            AABB areaToCheck = new AABB(pos).inflate(5.0, 2.0, 5.0);
            int entityCount = level.getEntitiesOfClass(Mob.class, areaToCheck, entity -> entity != null && entity.getType().getCategory() == MobCategory.CREATURE).size();
            if (entityCount < 8) {
                this.spawnMob(level, pos);
            }
            if (rand.nextInt(20) == 0 && level.getBlockState(posUp = pos.above()).isAir()) {
                PlacedFeature placedfeature;
                if (rand.nextInt(8) == 0) {
                    List list = ((Biome)level.getBiome(posUp).value()).getGenerationSettings().getFlowerFeatures();
                    if (list.isEmpty()) {
                        return;
                    }
                    placedfeature = (PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).config()).feature().value();
                } else {
                    placedfeature = (PlacedFeature)level.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).get(VegetationPlacements.GRASS_BONEMEAL);
                }
                placedfeature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), rand, posUp);
            }
        }
    }

    public void spawnMob(ServerLevel level, BlockPos pos) {
        Holder biomeHolder = level.getBiome(pos);
        Biome biome = !biomeHolder.is(ModTags.Biomes.PASSIVE_OVERRIDE) ? (Biome)biomeHolder.value() : level.registryAccess().registry(Registries.BIOME).flatMap(reg -> reg.getOptional(Biomes.PLAINS)).orElseGet(() -> ((Holder)biomeHolder).value());
        List spawns = biome.getMobSettings().getMobs(MobCategory.CREATURE).unwrap();
        if (!spawns.isEmpty()) {
            int indexSize = spawns.size();
            EntityType type = ((MobSpawnSettings.SpawnerData)spawns.get((int)level.random.nextInt((int)indexSize))).type;
            if (type.is(ModTags.Entities.NO_DIRT_SPAWN) || type.is(ModTags.Entities.NO_DELIGHTFUL_SPAWN)) {
                return;
            }
            Mob entity = (Mob)type.create((Level)level);
            if (entity == null) {
                return;
            }
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            if (!BlockDelightfulDirt.checkSpawnPosition(entity, (ServerLevelAccessor)level, MobSpawnType.NATURAL)) {
                return;
            }
            if (level.getEntities((EntityTypeTest)entity.getType(), entity.getBoundingBox(), EntitySelector.ENTITY_STILL_ALIVE).isEmpty() && level.noCollision((Entity)entity)) {
                TriState result = DirtSpawnEvent.checkEvent(entity, (LevelAccessor)level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, DirtSpawnEvent.DirtType.DELIGHTFUL);
                if (result == TriState.FALSE) {
                    return;
                }
                EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.NATURAL, null);
                level.addFreshEntity((Entity)entity);
            }
        }
    }

    @Nonnull
    public TriState canSustainPlant(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Direction facing, @Nonnull BlockState plant) {
        return TriState.TRUE;
    }

    public boolean isFlammable(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Direction face) {
        return true;
    }

    public int getFlammability(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Direction face) {
        return 200;
    }

    public boolean isFireSource(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return side == Direction.UP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@Nonnull BlockState stateIn, Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (level.getGameTime() % 3L == 0L && level.getBlockState(pos.above()).isAir()) {
            for (int i = 0; i < 4; ++i) {
                double d0 = pos.getX();
                double d1 = (double)pos.getY() + 1.0;
                double d2 = pos.getZ();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                MGUClientPackets.spawnGlitterParticles(d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
            }
        }
    }
}

