/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.extensions.gfmstrikethrough;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.ClassifyCharacter;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.Extension;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenProperty;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class GfmStrikethroughSyntax
extends Extension {
    public static final Extension INSTANCE = new GfmStrikethroughSyntax();
    public static final TokenProperty<Boolean> OPEN = new TokenProperty();
    public static final TokenProperty<Boolean> CLOSE = new TokenProperty();
    private static final String TYPE_STRIKETHROUGH_SEQUENCE_TEMPORARY = "strikethroughSequenceTemporary";
    static final String TOKEN = "strikethroughSequence";
    private final boolean singleTilde;

    public GfmStrikethroughSyntax() {
        this(Options.DEFAULT);
    }

    public GfmStrikethroughSyntax(Options options) {
        this.singleTilde = options.singleTilde();
        Construct tokenizer = new Construct();
        tokenizer.name = "strikethrough";
        tokenizer.tokenize = this::tokenizeStrikethrough;
        tokenizer.resolveAll = this::resolveAllStrikethrough;
        this.text.put(126, List.of(tokenizer));
        this.nullInsideSpan.add(tokenizer.resolveAll);
        this.nullAttentionMarkers.add(126);
    }

    private List<Tokenizer.Event> resolveAllStrikethrough(List<Tokenizer.Event> events, TokenizeContext context) {
        int index = -1;
        block0: while (++index < events.size()) {
            Tokenizer.Event event = events.get(index);
            Token token = event.token();
            if (!event.isEnter() || !token.type.equals(TYPE_STRIKETHROUGH_SEQUENCE_TEMPORARY) || !Boolean.TRUE.equals(token.get(CLOSE))) continue;
            int open = index;
            while (open-- > 0) {
                Tokenizer.Event openEvent = events.get(open);
                Token openToken = openEvent.token();
                if (!openEvent.isExit() || !openToken.type.equals(TYPE_STRIKETHROUGH_SEQUENCE_TEMPORARY) || !Boolean.TRUE.equals(openToken.get(OPEN)) || token.size() != openToken.size()) continue;
                events.get((int)index).token().type = TOKEN;
                events.get((int)open).token().type = TOKEN;
                Token strikethrough = new Token();
                strikethrough.type = "strikethrough";
                strikethrough.start = openToken.start;
                strikethrough.end = token.end;
                Token text = new Token();
                text.type = "strikethroughText";
                text.start = openToken.end;
                text.end = token.start;
                ArrayList<Tokenizer.Event> nextEvents = new ArrayList<Tokenizer.Event>();
                nextEvents.add(Tokenizer.Event.enter(strikethrough, context));
                nextEvents.add(Tokenizer.Event.enter(openToken, context));
                nextEvents.add(Tokenizer.Event.exit(openToken, context));
                nextEvents.add(Tokenizer.Event.enter(text, context));
                List<Construct.Resolver> insideSpan = context.getParser().constructs.nullInsideSpan;
                if (insideSpan != null) {
                    nextEvents.addAll(Construct.resolveAll(insideSpan, ListUtils.slice(events, open + 1, index), context));
                }
                nextEvents.add(Tokenizer.Event.exit(text, context));
                nextEvents.add(Tokenizer.Event.enter(token, context));
                nextEvents.add(Tokenizer.Event.exit(token, context));
                nextEvents.add(Tokenizer.Event.exit(strikethrough, context));
                ListUtils.splice(events, open - 1, index - open + 3, nextEvents);
                index = open + nextEvents.size() - 2;
                continue block0;
            }
        }
        for (Tokenizer.Event event : events) {
            if (!event.token().type.equals(TYPE_STRIKETHROUGH_SEQUENCE_TEMPORARY)) continue;
            event.token().type = "data";
        }
        return events;
    }

    private State tokenizeStrikethrough(final TokenizeContext context, final Tokenizer.Effects effects, final State ok, final State nok) {
        class StateMachine {
            final int previous;
            final List<Tokenizer.Event> events;
            int size;

            StateMachine() {
                this.previous = context.getPrevious();
                this.events = context.getEvents();
                this.size = 0;
            }

            State start(int code) {
                Assert.check(code == 126, "expected `~`");
                if (this.previous == 126 && !this.events.getLast().token().type.equals("characterEscape")) {
                    return nok.step(code);
                }
                effects.enter(GfmStrikethroughSyntax.TYPE_STRIKETHROUGH_SEQUENCE_TEMPORARY);
                return this.more(code);
            }

            State more(int code) {
                int before = ClassifyCharacter.classifyCharacter(this.previous);
                if (code == 126) {
                    if (this.size > 1) {
                        return nok.step(code);
                    }
                    effects.consume(code);
                    ++this.size;
                    return this::more;
                }
                if (this.size < 2 && !GfmStrikethroughSyntax.this.singleTilde) {
                    return nok.step(code);
                }
                Token token = effects.exit(GfmStrikethroughSyntax.TYPE_STRIKETHROUGH_SEQUENCE_TEMPORARY);
                int after = ClassifyCharacter.classifyCharacter(code);
                token.set(OPEN, after == 0 || after == 2 && before != 0);
                token.set(CLOSE, before == 0 || before == 2 && after != 0);
                return ok.step(code);
            }
        }
        return new StateMachine()::start;
    }

    public record Options(boolean singleTilde) {
        public static Options DEFAULT = new Options(true);
    }
}

