/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.AbstractMultiTermQueryConstantScoreWrapper;
import guideme.internal.shaded.lucene.search.ConstantScoreQuery;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.DisiPriorityQueue;
import guideme.internal.shaded.lucene.search.DisiWrapper;
import guideme.internal.shaded.lucene.search.DisjunctionDISIApproximation;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.TermQuery;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.DocIdSetBuilder;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.List;

final class MultiTermQueryConstantScoreBlendedWrapper<Q extends MultiTermQuery>
extends AbstractMultiTermQueryConstantScoreWrapper<Q> {
    private static final int POSTINGS_PRE_PROCESS_THRESHOLD = 512;

    MultiTermQueryConstantScoreBlendedWrapper(Q query) {
        super(query);
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new AbstractMultiTermQueryConstantScoreWrapper.RewritingWeight(this.query, boost, scoreMode, searcher){

            @Override
            protected AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator rewriteInner(LeafReaderContext context, int fieldDocCount, Terms terms, TermsEnum termsEnum, List<AbstractMultiTermQueryConstantScoreWrapper.TermAndState> collectedTerms) throws IOException {
                DocIdSetBuilder otherTerms = new DocIdSetBuilder(context.reader().maxDoc(), terms);
                PriorityQueue<PostingsEnum> highFrequencyTerms = new PriorityQueue<PostingsEnum>(this, collectedTerms.size()){

                    @Override
                    protected boolean lessThan(PostingsEnum a, PostingsEnum b) {
                        return a.cost() < b.cost();
                    }
                };
                PostingsEnum reuse = null;
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (AbstractMultiTermQueryConstantScoreWrapper.TermAndState termAndState : collectedTerms) {
                        termsEnum2.seekExact(termAndState.term, termAndState.state);
                        reuse = termsEnum2.postings(reuse, 0);
                        if (termAndState.docFreq <= 512) {
                            otherTerms.add(reuse);
                            continue;
                        }
                        highFrequencyTerms.add(reuse);
                        reuse = null;
                    }
                }
                do {
                    reuse = termsEnum.postings(reuse, 0);
                    int docFreq = termsEnum.docFreq();
                    if (fieldDocCount == docFreq) {
                        TermStates termStates = new TermStates(searcher.getTopReaderContext());
                        termStates.register(termsEnum.termState(), context.ord, docFreq, termsEnum.totalTermFreq());
                        ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery(new TermQuery(new Term(MultiTermQueryConstantScoreBlendedWrapper.this.query.field, termsEnum.term()), termStates));
                        Weight weight = searcher.rewrite(constantScoreQuery).createWeight(searcher, scoreMode, this.score());
                        return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(weight);
                    }
                    if (docFreq <= 512) {
                        otherTerms.add(reuse);
                        continue;
                    }
                    PostingsEnum dropped = highFrequencyTerms.insertWithOverflow(reuse);
                    if (dropped != null) {
                        otherTerms.add(dropped);
                    }
                    reuse = dropped;
                } while (termsEnum.next() != null);
                DisiPriorityQueue subs = new DisiPriorityQueue(highFrequencyTerms.size() + 1);
                for (DocIdSetIterator docIdSetIterator : highFrequencyTerms) {
                    Scorer s = MultiTermQueryConstantScoreBlendedWrapper.wrapWithDummyScorer(this, docIdSetIterator);
                    subs.add(new DisiWrapper(s, false));
                }
                Scorer s = MultiTermQueryConstantScoreBlendedWrapper.wrapWithDummyScorer(this, otherTerms.build().iterator());
                subs.add(new DisiWrapper(s, false));
                return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(new DisjunctionDISIApproximation(subs));
            }
        };
    }

    private static Scorer wrapWithDummyScorer(Weight weight, DocIdSetIterator disi) {
        return new ConstantScoreScorer(1.0f, ScoreMode.COMPLETE_NO_SCORES, disi);
    }
}

