/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.queries.intervals.Intervals;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import java.util.Locale;
import java.util.Objects;

public class NotWithin
extends IntervalFunction {
    private final int positions;
    private final IntervalFunction minuend;
    private final IntervalFunction subtrahend;

    public NotWithin(IntervalFunction minuend, int positions, IntervalFunction subtrahend) {
        this.positions = positions;
        this.minuend = Objects.requireNonNull(minuend);
        this.subtrahend = Objects.requireNonNull(subtrahend);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.notWithin(this.minuend.toIntervalSource(field, analyzer), this.positions, this.subtrahend.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:notWithin(%s %d %s)", this.minuend, this.positions, this.subtrahend);
    }
}

