/*
 * Decompiled with CFR 0.152.
 */
package guideme.color;

import net.minecraft.util.FastColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Colors {
    private static final Logger LOG = LoggerFactory.getLogger(Colors.class);

    Colors() {
    }

    public static int hexToRgb(String hexColor) {
        if (!hexColor.isEmpty()) {
            int remainingChars;
            int start = 0;
            if (hexColor.charAt(0) == '#') {
                ++start;
            }
            if ((remainingChars = hexColor.length() - start) == 3 || remainingChars == 4) {
                int r = Colors.fromHexChar(hexColor.charAt(start));
                int g = Colors.fromHexChar(hexColor.charAt(start + 1));
                int b = Colors.fromHexChar(hexColor.charAt(start + 2));
                int a = 15;
                if (remainingChars == 4) {
                    a = Colors.fromHexChar(hexColor.charAt(start + 3));
                }
                if (r != -1 && g != -1 && b != -1 && a != -1) {
                    return Colors.argb(a << 4 | a, r << 4 | r, g << 4 | g, b << 4 | b);
                }
            } else if (remainingChars == 6 || remainingChars == 8) {
                int rHi = Colors.fromHexChar(hexColor.charAt(start));
                int rLo = Colors.fromHexChar(hexColor.charAt(start + 1));
                int gHi = Colors.fromHexChar(hexColor.charAt(start + 2));
                int gLo = Colors.fromHexChar(hexColor.charAt(start + 3));
                int bHi = Colors.fromHexChar(hexColor.charAt(start + 4));
                int bLo = Colors.fromHexChar(hexColor.charAt(start + 5));
                int aHi = 15;
                int aLo = 15;
                if (remainingChars == 8) {
                    aHi = Colors.fromHexChar(hexColor.charAt(start + 6));
                    aLo = Colors.fromHexChar(hexColor.charAt(start + 7));
                }
                if (rHi != -1 && rLo != -1 && gHi != -1 && gLo != -1 && bHi != -1 && bLo != -1 && aHi != -1 && aLo != -1) {
                    return Colors.argb(aHi << 4 | aLo, rHi << 4 | rLo, gHi << 4 | gLo, bHi << 4 | bLo);
                }
            }
        }
        LOG.error("Tried to parse an invalid hexadecimal color string: '{}'", (Object)hexColor);
        return 0;
    }

    private static int fromHexChar(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return 10 + (ch - 97);
        }
        if (ch >= 65 && ch <= 70) {
            return 10 + (ch - 65);
        }
        return -1;
    }

    public static int argb(int a, int r, int g, int b) {
        return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
    }

    public static int rgb(int r, int g, int b) {
        return Colors.argb(255, r, g, b);
    }

    public static int mono(int w) {
        return Colors.rgb(w, w, w);
    }
}

