/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ForgeHandlerUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemHandlerExtractableStorage
implements ExtractableStorage {
    private final CapabilityCache capabilityCache;

    public ItemHandlerExtractableStorage(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof ItemResource)) {
            return 0L;
        }
        ItemResource itemResource = (ItemResource)resource;
        return this.capabilityCache.getItemHandler().map(itemHandler -> ForgeHandlerUtil.getCurrentAmount(itemHandler, itemResource.toItemStack())).orElse(0L);
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof ItemResource)) {
            return 0L;
        }
        ItemResource itemResource = (ItemResource)resource;
        return this.capabilityCache.getItemHandler().map(itemHandler -> this.extract(amount, action, (IItemHandler)itemHandler, itemResource.toItemStack(amount))).orElse(0L);
    }

    private long extract(long amount, Action action, IItemHandler itemHandler, ItemStack stack) {
        long toExtract;
        ItemStack stackInSlot;
        boolean relevant;
        long extracted = 0L;
        for (int slot = 0; !(slot >= itemHandler.getSlots() || (relevant = ItemStack.isSameItemSameComponents((ItemStack)(stackInSlot = itemHandler.getStackInSlot(slot)), (ItemStack)stack)) && (extracted += (long)this.extractSlot(action, itemHandler, stackInSlot, slot, (int)(toExtract = amount - extracted))) >= amount); ++slot) {
        }
        return extracted;
    }

    private int extractSlot(Action action, IItemHandler itemHandler, ItemStack stackInSlot, int slot, int amount) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case Action.SIMULATE -> {
                int amountInSlot = stackInSlot.getCount();
                int maxStackSize = stackInSlot.getMaxStackSize();
                int extracted = itemHandler.extractItem(slot, amount, true).getCount();
                if (amount > maxStackSize && extracted == maxStackSize && amountInSlot > maxStackSize) {
                    yield Math.min(amount, amountInSlot);
                }
                yield extracted;
            }
            case Action.EXECUTE -> {
                int toExtract;
                int totalExtracted;
                int extracted;
                for (totalExtracted = 0; totalExtracted < amount && (extracted = itemHandler.extractItem(slot, toExtract = amount - totalExtracted, false).getCount()) > 0; totalExtracted += extracted) {
                }
                yield totalExtracted;
            }
        };
    }
}

