/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class FilterWithFuzzyMode {
    private static final String TAG_FUZZY_MODE = "fm";
    private static final String TAG_RESOURCE_FILTER = "rf";
    private final ResourceContainer filterContainer;
    @Nullable
    private final Runnable listener;
    @Nullable
    private final Consumer<Set<ResourceKey>> uniqueFilterListener;
    @Nullable
    private final Consumer<List<ResourceKey>> filterListener;
    private boolean fuzzyMode;

    private FilterWithFuzzyMode(ResourceContainer filterContainer, @Nullable Runnable listener, @Nullable Consumer<Set<ResourceKey>> uniqueFilterListener, @Nullable Consumer<List<ResourceKey>> filterListener) {
        this.filterContainer = filterContainer;
        this.listener = listener;
        this.uniqueFilterListener = uniqueFilterListener;
        this.filterListener = filterListener;
        this.filterContainer.setListener(this::filterContainerChanged);
    }

    private void filterContainerChanged() {
        this.notifyListeners();
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public ResourceContainer getFilterContainer() {
        return this.filterContainer;
    }

    public boolean isFuzzyMode() {
        return this.fuzzyMode;
    }

    public void setFuzzyMode(boolean fuzzyMode) {
        this.fuzzyMode = fuzzyMode;
        this.notifyListeners();
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_RESOURCE_FILTER)) {
            this.filterContainer.fromTag(tag.getCompound(TAG_RESOURCE_FILTER), provider);
        }
        if (tag.contains(TAG_FUZZY_MODE)) {
            this.fuzzyMode = tag.getBoolean(TAG_FUZZY_MODE);
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        if (this.uniqueFilterListener != null) {
            this.uniqueFilterListener.accept(this.filterContainer.getUniqueResources());
        }
        if (this.filterListener != null) {
            this.filterListener.accept(this.filterContainer.getResources());
        }
    }

    public void save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putBoolean(TAG_FUZZY_MODE, this.fuzzyMode);
        tag.put(TAG_RESOURCE_FILTER, (Tag)this.filterContainer.toTag(provider));
    }

    public UnaryOperator<ResourceKey> createNormalizer() {
        return value -> {
            if (!this.fuzzyMode) {
                return value;
            }
            if (value instanceof FuzzyModeNormalizer) {
                FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)((Object)value);
                return normalizer.normalize();
            }
            return value;
        };
    }

    public static FilterWithFuzzyMode create(ResourceContainer resourceContainer, @Nullable Runnable listener) {
        return new FilterWithFuzzyMode(resourceContainer, listener, null, null);
    }

    public static FilterWithFuzzyMode createAndListenForFilters(ResourceContainer resourceContainer, Runnable listener, Consumer<List<ResourceKey>> filterListener) {
        return new FilterWithFuzzyMode(resourceContainer, listener, null, filterListener);
    }

    public static FilterWithFuzzyMode createAndListenForUniqueFilters(ResourceContainer resourceContainer, Runnable listener, Consumer<Set<ResourceKey>> filterListener) {
        return new FilterWithFuzzyMode(resourceContainer, listener, filterListener, null);
    }
}

