/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.portablegrid.AbstractPortableGridBlockEntity;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.render.AbstractDiskLedBlockEntityRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPortableGridBlockEntityRenderer<T extends AbstractPortableGridBlockEntity>
extends AbstractDiskLedBlockEntityRenderer<T> {
    private final RenderType renderType;

    protected AbstractPortableGridBlockEntityRenderer(RenderType renderType) {
        this.renderType = renderType;
    }

    @Nullable
    protected abstract Disk getDisk(T var1);

    public void render(T entity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        BlockState blockState = level.getBlockState(entity.getBlockPos());
        Block block = blockState.getBlock();
        if (!(block instanceof PortableGridBlock)) {
            return;
        }
        PortableGridBlock portableGridBlock = (PortableGridBlock)block;
        BiDirection direction = (BiDirection)((Object)portableGridBlock.getDirection(blockState));
        if (direction == null) {
            return;
        }
        this.render(entity, poseStack, vertexConsumers, direction);
    }

    private void render(T entity, PoseStack poseStack, MultiBufferSource vertexConsumers, BiDirection direction) {
        Disk disk = this.getDisk(entity);
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(direction.getQuaternion());
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(this.renderType);
        if (disk != null) {
            this.renderLed(poseStack, vertexConsumer, -1, 2, 12, disk, Direction.EAST);
        }
        poseStack.popPose();
    }
}

