/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum BuiltinPermission implements PlatformPermission
{
    INSERT("insert"),
    EXTRACT("extract"),
    AUTOCRAFTING("autocrafting"),
    OPEN("open"),
    BUILD("build"),
    SECURITY("security");

    private final ResourceLocation id;
    private final Component name;
    private final Component description;

    private BuiltinPermission(String id) {
        this.id = IdentifierUtil.createIdentifier(id);
        this.name = IdentifierUtil.createTranslation("permission", id);
        this.description = IdentifierUtil.createTranslation("permission", id + ".description");
    }

    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    @Override
    public Component getOwnerName() {
        return ContentNames.MOD;
    }

    @Override
    public boolean isAllowedByDefault() {
        return true;
    }
}

