/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class ResourceTypeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "grid.resource_type");
    private static final MutableComponent EMPTY_WARNING = IdentifierUtil.createTranslation("gui", "grid.resource_type.empty_warning");
    private static final List<MutableComponent> SUBTEXT_ALL = List.of(IdentifierUtil.createTranslation("gui", "grid.resource_type.all").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation ALL = IdentifierUtil.createIdentifier("widget/side_button/resource_type/all");
    private final AbstractGridContainerMenu menu;

    ResourceTypeSideButtonWidget(AbstractGridContainerMenu menu) {
        super(ResourceTypeSideButtonWidget.createPressAction(menu));
        this.menu = menu;
    }

    private static Button.OnPress createPressAction(AbstractGridContainerMenu menu) {
        return btn -> menu.toggleResourceType();
    }

    @Override
    protected ResourceLocation getSprite() {
        ResourceType resourceType = this.menu.getResourceType();
        if (resourceType == null) {
            return ALL;
        }
        return resourceType.getSprite();
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        ResourceType resourceType = this.menu.getResourceType();
        if (resourceType == null) {
            return SUBTEXT_ALL;
        }
        return List.of(resourceType.getTitle().withStyle(ChatFormatting.GRAY));
    }

    public void setWarningVisible(boolean visible) {
        if (visible) {
            this.setWarning((Component)EMPTY_WARNING);
        } else {
            this.setWarning(null);
        }
    }
}

