/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.typewriter;

import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.typewriter.TypewriterPage;
import com.github.minecraftschurlimods.bibliocraft.init.BCSoundEvents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TypewriterSyncPacket(BlockPos pos, TypewriterPage page, boolean playSound) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TypewriterSyncPacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("typewriter_sync"));
    public static final StreamCodec<ByteBuf, TypewriterSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TypewriterSyncPacket::pos, TypewriterPage.STREAM_CODEC, TypewriterSyncPacket::page, (StreamCodec)ByteBufCodecs.BOOL, TypewriterSyncPacket::playSound, TypewriterSyncPacket::new);

    public TypewriterSyncPacket(BlockPos pos, TypewriterPage page) {
        this(pos, page, false);
    }

    public void handle(IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(this.pos);
        if (blockEntity instanceof TypewriterBlockEntity) {
            TypewriterBlockEntity typewriter = (TypewriterBlockEntity)blockEntity;
            typewriter.setPage(this.page);
            if (this.playSound) {
                context.player().playSound((SoundEvent)BCSoundEvents.TYPEWRITER_CHIME.value());
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

