/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.component.CMDataComponents;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.capability.RoomCapabilities;
import dev.compactmods.machines.api.room.registration.IRoomRegistrar;
import dev.compactmods.machines.api.room.upgrade.IRoomUpgradeAccessor;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponent;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstance;
import dev.compactmods.machines.api.room.upgrade.component.RoomUpgradeComponentList;
import dev.compactmods.machines.api.room.upgrade.event.NeoForgeEventHandler;
import dev.compactmods.machines.api.room.upgrade.event.NeoForgeEventListener;
import dev.compactmods.machines.api.room.upgrade.event.RoomUpgradeComponentEvent;
import dev.compactmods.machines.api.room.upgrade.event.level.LevelLoadedUpgradeEventListener;
import dev.compactmods.machines.api.room.upgrade.event.level.LevelUnloadedUpgradeEventListener;
import dev.compactmods.machines.api.room.upgrade.event.lifecycle.UpgradeTickedEventListener;
import dev.compactmods.machines.api.room.upgrade.inventory.RoomUpgradeInventory;
import dev.compactmods.machines.feature.CMFeatureFlags;
import dev.compactmods.machines.room.upgrade.RoomUpgradeHelper;
import dev.compactmods.machines.room.upgrade.RoomUpgrades;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

public class RoomUpgradeEventHandlers {
    public static void collectUpgradeEvents() {
        HashSet allEvents = new HashSet();
        ((Registry)RoomUpgrades.ROOM_UPGRADE_DEFINITIONS.getRegistry().get()).forEach(upgradeType -> {
            RoomUpgradeComponent inst = (RoomUpgradeComponent)upgradeType.constructor().get();
            if (inst instanceof NeoForgeEventListener) {
                NeoForgeEventListener listener = (NeoForgeEventListener)inst;
                List<Class> eventTypes = listener.gatherNeoEvents().map(NeoForgeEventHandler::eventType).distinct().toList();
                allEvents.addAll(eventTypes);
            }
        });
        allEvents.forEach(RoomUpgrades::eventProcessor);
    }

    private static void doRoomUpgradeLoop(BiConsumer<RoomInstance, RoomUpgradeInventory> forEach) {
        IRoomRegistrar rooms = CompactMachines.roomRegistrar();
        if (rooms != null) {
            Set registeredRooms = rooms.allRooms().collect(Collectors.toUnmodifiableSet());
            for (RoomInstance room : registeredRooms) {
                ((IAttachmentHolder)room.getCapability(RoomCapabilities.ROOM_DATA_ATTACHMENTS)).getExistingData(CMDataAttachments.UPGRADE_ITEMS).ifPresent(i -> forEach.accept(room, (RoomUpgradeInventory)i));
            }
        }
    }

    public static void cleanupDeadUpgrades(ServerStartedEvent serverStartedEvent) {
        if (!CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(serverStartedEvent.getServer().getWorldData().enabledFeatures())) {
            return;
        }
        CompactMachines.roomRegistrar().allRooms().forEach(RoomUpgradeHelper::cleanDeadUpgrades);
    }

    public static void onLevelLoad(LevelEvent.Load loaded) {
        ServerLevel serverLevel;
        if (!CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(loaded.getLevel().enabledFeatures())) {
            return;
        }
        LevelAccessor levelAccessor = loaded.getLevel();
        if (levelAccessor instanceof ServerLevel && CompactDimension.isLevelCompact((Level)(serverLevel = (ServerLevel)levelAccessor))) {
            RoomUpgradeEventHandlers.doRoomUpgradeLoop((room, inv) -> RoomUpgradeEventHandlers.handleBasicEvent(room, inv, LevelLoadedUpgradeEventListener.class));
        }
    }

    public static void onLevelUnload(LevelEvent.Unload loaded) {
        ServerLevel serverLevel;
        if (!CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(loaded.getLevel().enabledFeatures())) {
            return;
        }
        LevelAccessor levelAccessor = loaded.getLevel();
        if (levelAccessor instanceof ServerLevel && CompactDimension.isLevelCompact((Level)(serverLevel = (ServerLevel)levelAccessor))) {
            RoomUpgradeEventHandlers.doRoomUpgradeLoop((room, inv) -> RoomUpgradeEventHandlers.handleBasicEvent(room, inv, LevelUnloadedUpgradeEventListener.class));
        }
    }

    public static void onLevelTick(LevelTickEvent.Post postTick) {
        ServerLevel serverLevel;
        if (!CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(postTick.getLevel().enabledFeatures())) {
            return;
        }
        Level level = postTick.getLevel();
        if (level instanceof ServerLevel && CompactDimension.isLevelCompact((Level)(serverLevel = (ServerLevel)level))) {
            RoomUpgradeEventHandlers.doRoomUpgradeLoop((room, inv) -> RoomUpgradeEventHandlers.handleBasicEvent(room, inv, UpgradeTickedEventListener.class));
        }
    }

    private static <Evt extends RoomUpgradeComponentEvent> void handleBasicEvent(RoomInstance room, @NotNull RoomUpgradeInventory appliedUpgrades, Class<Evt> eventType) {
        Set upgradeInstances = appliedUpgrades.items().map(stack -> (UUID)stack.get((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        IRoomUpgradeAccessor upgradeAccessor = (IRoomUpgradeAccessor)room.getCapability(RoomCapabilities.UPGRADES);
        if (upgradeAccessor != null) {
            for (UUID upgradeId : upgradeInstances) {
                RoomUpgradeInstance instance = upgradeAccessor.getOrCreateInstance(upgradeId);
                if (instance.upgradeItem().isEmpty()) {
                    upgradeAccessor.remove(instance.upgradeID());
                    instance.upgradeItem().remove((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID);
                    return;
                }
                RoomUpgradeComponentList upgrades = (RoomUpgradeComponentList)instance.upgradeItem().get((Supplier)CMDataComponents.UPGRADE_LIST_COMPONENT);
                if (upgrades == null) continue;
                upgrades.components().stream().flatMap(ru -> ru.gatherEvents().filter(eventType::isInstance)).map(eventType::cast).forEach(loadHandler -> loadHandler.handle(instance));
            }
        }
    }

    public static void onTooltips(ItemTooltipEvent evt) {
        Item.TooltipContext ctx = evt.getContext();
        Consumer<Component> tooltips = evt.getToolTip()::add;
        TooltipFlag flags = evt.getFlags();
        ItemStack stack = evt.getItemStack();
        if (stack.has((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID)) {
            UUID id = (UUID)stack.get((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID);
            tooltips.accept((Component)Component.literal((String)("ID: " + String.valueOf(id))).withColor(-8355712));
        }
        stack.addToTooltip((Supplier)CMDataComponents.UPGRADE_LIST_COMPONENT, ctx, tooltips, flags);
    }
}

