/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwbyg;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.AddFurnituresStorage;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.mapping.MappingMissing;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.addonslib.windows.Windows;
import fr.samlegamer.mcwbyg.Recipes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwbyg")
public class McwByg
extends McwMod {
    public static final String MODID = "mcwbyg";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD = List.of("aspen", "baobab", "blue_enchanted", "cika", "cypress", "ebony", "fir", "green_enchanted", "holly", "ironwood", "jacaranda", "mahogany", "maple", "palm", "pine", "rainbow_eucalyptus", "redwood", "sakura", "skyris", "white_mangrove", "willow", "witch_hazel", "zelkova", "florus");
    public static final List<String> STONE = List.of("dacite_bricks", "red_rock_bricks", "pink_sandstone", "white_sandstone", "blue_sandstone", "purple_sandstone", "black_sandstone", "windswept_sandstone");
    public static final List<String> LEAVES = List.of("aspen", "baobab", "blue_enchanted", "cika", "cypress", "ebony", "fir", "green_enchanted", "holly", "ironwood", "jacaranda", "mahogany", "maple", "palm", "pine", "rainbow_eucalyptus", "redwood", "skyris", "white_mangrove", "willow", "witch_hazel", "zelkova", "blue_spruce", "orange_spruce", "red_spruce", "yellow_spruce", "brown_birch", "orange_birch", "red_birch", "yellow_birch", "brown_oak", "orange_oak", "red_oak", "white_sakura", "yellow_sakura", "red_maple", "araucaria", "blooming_witch_hazel", "flowering_indigo_jacaranda", "flowering_ironwood", "flowering_jacaranda", "flowering_orchard", "flowering_palo_verde", "flowering_skyris", "flowering_yucca");
    private static final DeferredRegister.Blocks block = Registration.blocks((String)"mcwbyg");
    private static final DeferredRegister.Items item = Registration.items((String)"mcwbyg");
    public static final DeferredRegister<CreativeModeTab> ct = Registration.creativeModeTab((String)"mcwbyg");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MCWBYG_TAB = ct.register("tab", () -> CreativeModeTab.builder().icon(McwByg::getIcon).title((Component)Component.translatable((String)"mcwbyg.tab")).build());
    private static final MappingMissing.Bridges bridges = new MappingMissing.Bridges("macawsbridgesbyg", "mcwbyg", WOOD, STONE);
    private static final MappingMissing.Furnitures furnitures = new MappingMissing.Furnitures("mcwfurnituresbyg", "mcwbyg", WOOD);
    private static final MappingMissing.Fences fences = new MappingMissing.Fences("mcwfencesbyg", "mcwbyg", WOOD, STONE);
    private static final MappingMissing.Roofs roofs = new MappingMissing.Roofs("macawsroofsbyg", "mcwbyg", WOOD);

    public McwByg(IEventBus bus) {
        super(bus);
        List<String> leavesClassic = List.of("aspen", "baobab", "blue_enchanted", "cika", "cypress", "ebony", "fir", "green_enchanted", "holly", "ironwood", "jacaranda", "mahogany", "maple", "palm", "pine", "rainbow_eucalyptus", "redwood", "skyris", "white_mangrove", "willow", "witch_hazel", "zelkova", "blue_spruce", "orange_spruce", "red_spruce", "yellow_spruce", "brown_birch", "orange_birch", "red_birch", "yellow_birch", "brown_oak", "orange_oak", "red_oak", "red_maple", "araucaria", "blooming_witch_hazel", "flowering_indigo_jacaranda", "flowering_ironwood", "flowering_jacaranda", "flowering_orchard", "flowering_palo_verde", "flowering_skyris", "flowering_yucca");
        List<String> leavesCherry = List.of("white_sakura", "yellow_sakura");
        LOGGER.info("Macaw's Oh the Biomes You'll Go Loading...");
        Registration.init((IEventBus)bus, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, ct);
        Bridges.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Bridges.setRegistrationRock(STONE, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Roofs.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Roofs.setRegistrationRock(STONE, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Fences.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Fences.setRegistrationHedges(leavesClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Fences.setRegistrationHedgesModLoaded(leavesCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LEAVES));
        Fences.setRegistrationRock(STONE, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Furnitures.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Stairs.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Paths.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Doors.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Trapdoors.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Windows.setRegistrationWood(WOOD, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        LOGGER.info("Converting Loading...");
        fences.leavesAdding(LEAVES);
        bridges.missingnoWoodBlock(block);
        bridges.missingnoStoneBlock(block, true);
        furnitures.missingnoWoodBlock(block);
        fences.missingnoWoodBlock(block);
        fences.missingnoStoneBlock(block);
        roofs.missingnoWoodBlock(block);
        fences.leavesAdding(LEAVES);
        bridges.missingnoWoodItem(item);
        bridges.missingnoStoneItem(item, true);
        furnitures.missingnoWoodItem(item);
        fences.missingnoWoodItem(item);
        fences.missingnoStoneItem(item);
        roofs.missingnoWoodItem(item);
        LOGGER.info("Converting Finish !");
        bus.addListener(this::addFurnitures);
        bus.addListener(this::clientSetup);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::tabSetup);
        LOGGER.info("Macaw's Oh the Biomes You'll Go Is Charged !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVES);
        APIRenderTypes.initAllStone((FMLClientSetupEvent)event, (String)MODID, STONE, (ModType[])Registration.getAllModTypeStone());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD);
            McwLootTables.addBlockHedges((String)MODID, LEAVES);
            McwLootTables.addBlockAllStone((String)MODID, STONE);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture registries = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(this, output, registries, MODID, existingFileHelper){

                protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider provider) {
                    this.addAllMcwTags(McwByg.MODID, WOOD, STONE, LEAVES);
                }
            };
            generator.addProvider(true, (DataProvider)new Recipes(output, registries));
            generator.addProvider(true, (DataProvider)mcwBlockTags);
            generator.addProvider(true, (DataProvider)new McwItemTags(this, output, registries, mcwBlockTags.contentsGetter(), MODID, existingFileHelper){

                protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider provider) {
                    this.addAllMcwTags(McwByg.MODID, WOOD, STONE, LEAVES);
                }
            });
        }
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, WOOD, (CreativeModeTab)((CreativeModeTab)MCWBYG_TAB.get()), (ModType[])Registration.getAllModTypeWood());
        APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, LEAVES, (CreativeModeTab)((CreativeModeTab)MCWBYG_TAB.get()));
        APICreativeTab.initAllStone((BuildCreativeModeTabContentsEvent)event, (String)MODID, STONE, (CreativeModeTab)((CreativeModeTab)MCWBYG_TAB.get()), (ModType[])Registration.getAllModTypeStone());
    }

    private void addFurnitures(BlockEntityTypeAddBlocksEvent event) {
        AddFurnituresStorage.addCompatibleBlocksToFurnitureStorage((BlockEntityTypeAddBlocksEvent)event, (String)MODID, WOOD);
    }

    private static ItemStack getIcon() {
        NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"aspen_roof"), Finder.findBlock((String)MODID, (String)"aspen_picket_fence"), Finder.findBlock((String)MODID, (String)"aspen_wardrobe"), Finder.findBlock((String)MODID, (String)"aspen_log_bridge_middle"), Finder.findBlock((String)MODID, (String)"aspen_plank_window2"), Finder.findBlock((String)MODID, (String)"aspen_paper_door"), Finder.findBlock((String)MODID, (String)"aspen_blossom_trapdoor"), Finder.findBlock((String)MODID, (String)"aspen_planks_path"), Finder.findBlock((String)MODID, (String)"aspen_bulk_stairs"));
        prop.addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.STAIRS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.TRAPDOORS).addType(NewIconRandom.BlockType.PATHS).addType(NewIconRandom.BlockType.WINDOWS);
        return new ItemStack((ItemLike)prop.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.STAIRS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.TRAPDOORS, NewIconRandom.BlockType.PATHS, NewIconRandom.BlockType.WINDOWS}));
    }
}

