/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;

@NothingNullByDefault
public class EnergyDisplay
implements IHasTextComponent {
    public static final EnergyDisplay ZERO = EnergyDisplay.of(0L);
    private final long energy;
    private final long max;

    private EnergyDisplay(long energy, long max) {
        this.energy = Math.max(0L, energy);
        this.max = Math.max(0L, max);
    }

    public static EnergyDisplay of(IEnergyContainer container) {
        return EnergyDisplay.of(container.getEnergy(), container.getMaxEnergy());
    }

    public static EnergyDisplay of(long energy, long max) {
        return new EnergyDisplay(energy, max);
    }

    public static EnergyDisplay of(long energy) {
        return EnergyDisplay.of(energy, 0L);
    }

    @Override
    public Component getTextComponent() {
        if (this.energy == Long.MAX_VALUE) {
            return MekanismLang.INFINITE.translate();
        }
        if (this.max == 0L) {
            return MekanismUtils.getEnergyDisplayShort(this.energy);
        }
        return MekanismLang.GENERIC_FRACTION.translate(MekanismUtils.getEnergyDisplayShort(this.energy), EnergyDisplay.of(this.max));
    }
}

