/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public interface IRedstoneControl {
    public RedstoneControl getControlType();

    public void setControlType(RedstoneControl var1);

    public boolean isPowered();

    public boolean wasPowered();

    public boolean supportsMode(RedstoneControl var1);

    @NothingNullByDefault
    public static enum RedstoneControl implements IIncrementalEnum<RedstoneControl>,
    IHasTextComponent.IHasEnumNameTextComponent,
    StringRepresentable
    {
        DISABLED(MekanismLang.REDSTONE_CONTROL_DISABLED),
        HIGH(MekanismLang.REDSTONE_CONTROL_HIGH),
        LOW(MekanismLang.REDSTONE_CONTROL_LOW),
        PULSE(MekanismLang.REDSTONE_CONTROL_PULSE);

        public static final Codec<RedstoneControl> CODEC;
        public static final IntFunction<RedstoneControl> BY_ID;
        public static final StreamCodec<ByteBuf, RedstoneControl> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ILangEntry langEntry;

        private RedstoneControl(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate();
        }

        @Override
        public RedstoneControl byIndex(int index) {
            return BY_ID.apply(index);
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(RedstoneControl::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])RedstoneControl.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

