/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.Upgrade;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IUpgradeItem;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.WorldUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemUpgrade
extends Item
implements IUpgradeItem {
    private final Upgrade upgrade;

    public ItemUpgrade(Upgrade type, Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON));
        this.upgrade = type;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            Upgrade upgradeType = this.getUpgradeType(stack);
            tooltip.add(upgradeType.getDescription());
            tooltip.add((Component)APILang.UPGRADE_MAX_INSTALLED.translate(upgradeType.getMax()));
        } else {
            tooltip.add((Component)MekanismLang.HOLD_FOR_DETAILS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()));
        }
    }

    @Override
    public Upgrade getUpgradeType(ItemStack stack) {
        return this.upgrade;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack;
        Upgrade type;
        TileComponentUpgrade component;
        IUpgradeTile upgradeTile;
        Level world;
        BlockEntity tile;
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown() && (tile = WorldUtils.getTileEntity((BlockGetter)(world = context.getLevel()), context.getClickedPos())) instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)tile).supportsUpgrades() && (component = upgradeTile.getComponent()).supports(type = this.getUpgradeType(stack = context.getItemInHand()))) {
            int added;
            if (!world.isClientSide && (added = component.addUpgrades(type, stack.getCount())) > 0) {
                stack.shrink(added);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

