/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=ChemicalStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient")
public class CrTChemicalStackIngredient {
    private CrTChemicalStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    @Deprecated(forRemoval=true, since="10.7.11")
    public static ChemicalStackIngredient from(Chemical chemical, long amount) {
        CrTChemicalStackIngredient.assertValidAmount(amount);
        if (chemical.isEmptyType()) {
            throw new IllegalArgumentException("ChemicalStackIngredients cannot be created from an empty chemical.");
        }
        return IngredientCreatorAccess.chemicalStack().from((IChemicalProvider)chemical, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient from(ICrTChemicalStack instance) {
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("ChemicalStackIngredients cannot be created from an empty stack.");
        }
        return IngredientCreatorAccess.chemicalStack().from(instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    @Deprecated(forRemoval=true, since="10.7.11")
    public static ChemicalStackIngredient from(long amount, Chemical ... chemicals) {
        return CrTChemicalStackIngredient.from(amount, Arrays.stream(chemicals).map(Chemical::getAsHolder));
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient from(long amount, ICrTChemicalStack ... chemicals) {
        return CrTChemicalStackIngredient.from(amount, Arrays.stream(chemicals).map(ICrTChemicalStack::getChemicalHolder));
    }

    private static ChemicalStackIngredient from(long amount, Stream<Holder<Chemical>> holders) {
        CrTChemicalStackIngredient.assertValidAmount(amount);
        Holder[] chemicals = (Holder[])holders.toArray(Holder[]::new);
        if (chemicals.length == 0) {
            throw new IllegalArgumentException("ChemicalStackIngredients cannot be created from zero chemicals.");
        }
        for (Holder instance : chemicals) {
            if (!instance.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) continue;
            throw new IllegalArgumentException("ChemicalStackIngredients cannot be created from an empty chemical.");
        }
        return IngredientCreatorAccess.chemicalStack().fromHolders(amount, chemicals);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient from(ICrTChemicalStack ... chemicals) {
        if (chemicals == null || chemicals.length == 0) {
            throw new IllegalArgumentException("ChemicalStackIngredients cannot be created from zero chemicals.");
        }
        ArrayList<ChemicalIngredient> ingredients = new ArrayList<ChemicalIngredient>(chemicals.length);
        long amount = 0L;
        for (ICrTChemicalStack instance : chemicals) {
            if (instance.isEmpty()) {
                throw new IllegalArgumentException("ChemicalStackIngredients cannot be created from an empty chemical.");
            }
            if (amount == 0L) {
                amount = instance.getAmount();
            }
            ingredients.add(IngredientCreatorAccess.chemical().of(instance.getChemicalHolder()));
        }
        CrTChemicalStackIngredient.assertValidAmount(amount);
        return IngredientCreatorAccess.chemicalStack().from(IngredientCreatorAccess.chemical().ofIngredients(ingredients), amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient from(KnownTag<Chemical> chemicalTag, long amount) {
        CrTChemicalStackIngredient.assertValidAmount(amount);
        TagKey<Chemical> tag = CrTUtils.validateTagAndGet(chemicalTag);
        return IngredientCreatorAccess.chemicalStack().from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient from(Many<KnownTag<Chemical>> chemicalTag) {
        return CrTChemicalStackIngredient.from((KnownTag<Chemical>)((KnownTag)chemicalTag.getData()), (long)chemicalTag.getAmount());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(ChemicalStackIngredient _this) {
        return (IData)IngredientCreatorAccess.chemicalStack().codec().encodeStart((DynamicOps)IDataOps.INSTANCE.withRegistryAccess(), (Object)_this).getOrThrow();
    }

    @ZenCodeType.Method
    public static boolean testType(ChemicalStackIngredient _this, ICrTChemicalStack type) {
        return _this.testType(type.getInternal());
    }

    @ZenCodeType.Method
    @Deprecated(forRemoval=true, since="10.7.11")
    public static boolean testType(ChemicalStackIngredient _this, Chemical chemical) {
        return _this.testType(chemical);
    }

    @ZenCodeType.Method
    public static boolean test(ChemicalStackIngredient _this, ICrTChemicalStack stack) {
        return _this.test(stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<ICrTChemicalStack> getRepresentations(ChemicalStackIngredient _this) {
        return CrTUtils.convertChemical(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static ChemicalStackIngredient or(ChemicalStackIngredient _this, ChemicalStackIngredient other) {
        if (_this.amount() != other.amount()) {
            throw new IllegalArgumentException("ChemicalStack ingredients can only be or'd if they have the same counts");
        }
        ArrayList ingredients = new ArrayList();
        CrTChemicalStackIngredient.addIngredient(ingredients, _this.ingredient());
        CrTChemicalStackIngredient.addIngredient(ingredients, other.ingredient());
        return IngredientCreatorAccess.chemicalStack().from(IngredientCreatorAccess.chemical().ofIngredients(ingredients), _this.amount());
    }

    private static void assertValidAmount(long amount) {
        if (amount <= 0L) {
            throw new IllegalArgumentException("ChemicalStackIngredients can only be created with a size of at least one. Received size was: " + amount);
        }
    }

    private static <INGREDIENT extends ChemicalIngredient> void addIngredient(List<INGREDIENT> ingredients, INGREDIENT ingredient) {
        if (ingredient instanceof CompoundChemicalIngredient) {
            CompoundChemicalIngredient compoundIngredient = (CompoundChemicalIngredient)ingredient;
            ingredients.addAll(compoundIngredient.children());
        } else {
            ingredients.add(ingredient);
        }
    }
}

