/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.listener;

import java.util.function.LongSupplier;
import mekanism.common.config.value.CachedValue;

public class ConfigBasedCachedLongSupplier
implements LongSupplier {
    private final LongSupplier resolver;
    private boolean resolved;
    private long cachedValue;

    public ConfigBasedCachedLongSupplier(LongSupplier resolver, CachedValue<?> ... dependantConfigValues) {
        this.resolver = resolver;
        CachedValue.IConfigValueInvalidationListener refreshListener = this::refresh;
        for (CachedValue<?> configValue : dependantConfigValues) {
            configValue.addInvalidationListener(refreshListener);
        }
    }

    protected final void refresh() {
        this.cachedValue = this.resolver.getAsLong();
        this.resolved = true;
    }

    @Override
    public long getAsLong() {
        if (!this.resolved) {
            this.refresh();
        }
        return this.cachedValue;
    }
}

