/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.resolver;

import java.util.List;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@NothingNullByDefault
public class BasicCapabilityResolver<CAPABILITY, CONTEXT>
implements ICapabilityResolver<CONTEXT> {
    private final List<BlockCapability<?, CONTEXT>> supportedCapabilities;
    private final Supplier<CAPABILITY> supplier;
    @Nullable
    private CAPABILITY cachedCapability;

    public static <CAPABILITY, CONTEXT> BasicCapabilityResolver<CAPABILITY, CONTEXT> create(BlockCapability<CAPABILITY, CONTEXT> supportedCapability, Supplier<CAPABILITY> supplier) {
        return new BasicCapabilityResolver<CAPABILITY, CONTEXT>(supportedCapability, supplier);
    }

    public static <CAPABILITY, CONTEXT> BasicCapabilityResolver<CAPABILITY, CONTEXT> persistent(BlockCapability<CAPABILITY, CONTEXT> supportedCapability, Supplier<CAPABILITY> supplier) {
        return BasicCapabilityResolver.create(supportedCapability, supplier instanceof Lazy ? supplier : Lazy.of(supplier));
    }

    protected BasicCapabilityResolver(BlockCapability<CAPABILITY, CONTEXT> capabilityType, Supplier<CAPABILITY> supplier) {
        this.supportedCapabilities = List.of(capabilityType);
        this.supplier = supplier;
    }

    @Override
    public List<BlockCapability<?, CONTEXT>> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @Override
    @Nullable
    public <T> T resolve(BlockCapability<T, CONTEXT> capability, @UnknownNullability CONTEXT context) {
        if (this.cachedCapability == null) {
            this.cachedCapability = this.supplier.get();
        }
        return (T)this.cachedCapability;
    }

    @Override
    public void invalidate(BlockCapability<?, CONTEXT> capability, @UnknownNullability CONTEXT side) {
        this.cachedCapability = null;
    }

    @Override
    public void invalidateAll() {
        this.cachedCapability = null;
    }
}

