/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class MekFakePlayer
extends FakePlayer {
    private static WeakReference<MekFakePlayer> INSTANCE;
    private UUID emulatingUUID = null;

    private MekFakePlayer(ServerLevel world) {
        super(world, (GameProfile)new FakeGameProfile());
        ((FakeGameProfile)this.getGameProfile()).myFakePlayer = this;
    }

    public boolean canBeAffected(@NotNull MobEffectInstance effect) {
        return false;
    }

    public void setEmulatingUUID(UUID uuid) {
        this.emulatingUUID = uuid;
    }

    @NotNull
    public UUID getUUID() {
        return this.emulatingUUID == null ? super.getUUID() : this.emulatingUUID;
    }

    public void cleanupFakePlayer(ServerLevel world) {
        this.emulatingUUID = null;
        this.setServerLevel(world.getServer().overworld());
    }

    public static MekFakePlayer setupFakePlayer(ServerLevel world) {
        MekFakePlayer actual;
        MekFakePlayer mekFakePlayer = actual = INSTANCE == null ? null : (MekFakePlayer)((Object)INSTANCE.get());
        if (actual == null) {
            actual = new MekFakePlayer(world);
            INSTANCE = new WeakReference<MekFakePlayer>(actual);
        }
        MekFakePlayer player = actual;
        player.setServerLevel(world);
        return player;
    }

    public static MekFakePlayer setupFakePlayer(ServerLevel world, double x, double y, double z) {
        MekFakePlayer player = MekFakePlayer.setupFakePlayer(world);
        player.setPosRaw(x, y, z);
        return player;
    }

    public static <R> R withFakePlayer(ServerLevel world, Function<MekFakePlayer, R> fakePlayerConsumer) {
        MekFakePlayer player = MekFakePlayer.setupFakePlayer(world);
        R result = fakePlayerConsumer.apply(player);
        player.cleanupFakePlayer(world);
        return result;
    }

    public static <R> R withFakePlayer(ServerLevel world, double x, double y, double z, Function<MekFakePlayer, R> fakePlayerConsumer) {
        MekFakePlayer player = MekFakePlayer.setupFakePlayer(world, x, y, z);
        R result = fakePlayerConsumer.apply(player);
        player.cleanupFakePlayer(world);
        return result;
    }

    public static void releaseInstance(ServerLevel world) {
        MekFakePlayer actual;
        MekFakePlayer mekFakePlayer = actual = INSTANCE == null ? null : (MekFakePlayer)((Object)INSTANCE.get());
        if (actual != null && actual.serverLevel() == world) {
            actual.setServerLevel(world.getServer().overworld());
        }
    }

    private static class FakeGameProfile
    extends GameProfile {
        private MekFakePlayer myFakePlayer = null;

        public FakeGameProfile() {
            super(Mekanism.gameProfile.getId(), Mekanism.gameProfile.getName());
        }

        private UUID getEmulatingUUID() {
            return this.myFakePlayer == null ? null : this.myFakePlayer.emulatingUUID;
        }

        public UUID getId() {
            UUID emulatingUUID = this.getEmulatingUUID();
            return emulatingUUID == null ? super.getId() : emulatingUUID;
        }

        public String getName() {
            UUID emulatingUUID = this.getEmulatingUUID();
            return emulatingUUID == null ? super.getName() : MekanismUtils.getLastKnownUsername(emulatingUUID);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GameProfile)) {
                return false;
            }
            GameProfile that = (GameProfile)o;
            return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName());
        }

        public int hashCode() {
            UUID id = this.getId();
            String name = this.getName();
            int result = id == null ? 0 : id.hashCode();
            result = 31 * result + (name == null ? 0 : name.hashCode());
            return result;
        }
    }
}

