/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.custom.GuiQIOCrystallizerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalCrystallizerRecipeCategory
extends HolderRecipeCategory<ChemicalCrystallizerRecipe> {
    private static final String CHEMICAL_INPUT = "chemicalInput";
    private static final String DISPLAYED_ITEM = "displayedItem";
    private final OreInfo oreInfo = new OreInfo();
    private final GuiGauge<?> gauge;
    private final GuiSlot output;
    private final GuiQIOCrystallizerScreen screen;

    public ChemicalCrystallizerRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<ChemicalCrystallizerRecipe> recipeType) {
        super(helper, recipeType);
        GaugeType type = GaugeType.STANDARD.with(DataType.INPUT);
        this.gauge = this.addElement(GuiChemicalGauge.getDummy(type, this, 7, 4));
        this.addSlot(SlotType.INPUT, 8, 65).with(SlotOverlay.PLUS);
        this.output = this.addSlot(SlotType.OUTPUT, 129, 57);
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 53, 61);
        this.screen = this.addElement(new GuiQIOCrystallizerScreen((IGuiWrapper)this, 31, 13, 115, 42, this.oreInfo));
    }

    @Override
    public void draw(RecipeHolder<ChemicalCrystallizerRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.oreInfo.currentRecipe = (ChemicalCrystallizerRecipe)recipeHolder.value();
        this.oreInfo.ingredient = recipeSlotsView.findSlotByName(CHEMICAL_INPUT).flatMap(IRecipeSlotView::getDisplayedIngredient).map(ITypedIngredient::getIngredient).filter(ingredient -> ingredient instanceof ChemicalStack).orElse(null);
        this.oreInfo.itemIngredient = this.getDisplayedStack(recipeSlotsView, DISPLAYED_ITEM, VanillaTypes.ITEM_STACK, ItemStack.EMPTY);
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.oreInfo.currentRecipe = null;
        this.oreInfo.ingredient = null;
        this.oreInfo.itemIngredient = ItemStack.EMPTY;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ChemicalCrystallizerRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        ChemicalCrystallizerRecipe recipe = (ChemicalCrystallizerRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
        ChemicalStackIngredient input = recipe.getInput();
        this.initChemical(builder, RecipeIngredientRole.INPUT, this.gauge, input.getRepresentations()).setSlotName(CHEMICAL_INPUT);
        List<ItemStack> displayItems = RecipeViewerUtils.getDisplayItems(input);
        if (!displayItems.isEmpty()) {
            this.initItem(builder, RecipeIngredientRole.RENDER_ONLY, this.screen.getSlotX(), this.screen.getSlotY(), displayItems).setSlotName(DISPLAYED_ITEM);
        }
    }

    private static class OreInfo
    implements GuiQIOCrystallizerScreen.IOreInfo {
        @Nullable
        private ChemicalCrystallizerRecipe currentRecipe;
        @Nullable
        private ChemicalStack ingredient;
        private ItemStack itemIngredient = ItemStack.EMPTY;

        private OreInfo() {
        }

        @Override
        @NotNull
        public ChemicalStack getInputChemical() {
            if (this.ingredient == null || this.ingredient.isEmpty()) {
                return ChemicalStack.EMPTY;
            }
            return this.ingredient;
        }

        @Override
        @Nullable
        public ChemicalCrystallizerRecipe getRecipe() {
            return this.currentRecipe;
        }

        @Override
        @NotNull
        public ItemStack getRenderStack() {
            return this.itemIngredient;
        }

        @Override
        public boolean usesSequencedDisplay() {
            return false;
        }
    }
}

