/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.util.ArrayList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.tile.machine.TileEntityElectricPump;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GuiElectricPump
extends GuiMekanismTile<TileEntityElectricPump, MekanismTileContainer<TileEntityElectricPump>> {
    public GuiElectricPump(MekanismTileContainer<TileEntityElectricPump> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.titleLabelY = 5;
        this.inventoryLabelY += 2;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 54, 23, 80, 42, () -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(EnergyDisplay.of(((TileEntityElectricPump)this.tile).getEnergyContainer()).getTextComponent());
            FluidStack fluidStack = ((TileEntityElectricPump)this.tile).fluidTank.getFluid();
            if (fluidStack.isEmpty()) {
                FluidStack fallBack = ((TileEntityElectricPump)this.tile).getActiveType();
                if (fallBack.isEmpty()) {
                    list.add(MekanismLang.NO_FLUID.translate());
                } else {
                    list.add(fallBack.getHoverName());
                }
            } else {
                list.add(MekanismLang.GENERIC_STORED_MB.translate(fluidStack, TextUtils.format(fluidStack.getAmount())));
            }
            return list;
        }));
        this.addRenderableWidget(new GuiDownArrow(this, 32, 39));
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityElectricPump)this.tile).getEnergyContainer(), 164, 15)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            MachineEnergyContainer<TileEntityElectricPump> energyContainer = ((TileEntityElectricPump)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick() > energyContainer.getEnergy();
        });
        this.addRenderableWidget(new GuiFluidGauge(() -> ((TileEntityElectricPump)this.tile).fluidTank, () -> ((TileEntityElectricPump)this.tile).getFluidTanks(null), GaugeType.STANDARD, this, 6, 13)).warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, () -> ((TileEntityElectricPump)this.tile).fluidTank.getNeeded() < ((TileEntityElectricPump)this.tile).estimateIncrementAmount());
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityElectricPump)this.tile).getEnergyContainer(), ((TileEntityElectricPump)this.tile)::usedEnergy));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

