/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public non-sealed class SingleChemicalIngredient
extends ChemicalIngredient {
    public static final MapCodec<SingleChemicalIngredient> CODEC = ChemicalStack.CHEMICAL_NON_EMPTY_HOLDER_CODEC.xmap(SingleChemicalIngredient::new, SingleChemicalIngredient::chemical).fieldOf("chemical");
    private final Holder<Chemical> chemical;

    public SingleChemicalIngredient(Holder<Chemical> chemical) {
        if (chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            throw new IllegalStateException("SingleChemicalIngredient must not be constructed with mekanism:empty, use IChemicalIngredientCreator.empty() instead!");
        }
        this.chemical = chemical;
    }

    @Override
    public final boolean test(Holder<Chemical> chemical) {
        return chemical.is(this.chemical);
    }

    @Override
    public final Stream<Holder<Chemical>> generateChemicalHolders() {
        return Stream.of(this.chemical);
    }

    public final Holder<Chemical> chemical() {
        return this.chemical;
    }

    public MapCodec<SingleChemicalIngredient> codec() {
        return CODEC;
    }

    @Override
    public void logMissingTags() {
        if (!this.chemical.isBound()) {
            MekanismAPI.logger.error("Unbound chemical: {}", (Object)this.chemical.getRegisteredName());
        }
    }

    @Override
    public int hashCode() {
        return ((Chemical)this.chemical.value()).hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.test(((SingleChemicalIngredient)obj).chemical);
    }
}

