/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends AbstractContainerScreen<X> {
    private static final ResourceLocation SLOT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"textures/gui/slot.png");
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.getInventory(), (Component)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void init() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.imageWidth = this.widget.width();
        this.imageHeight = this.widget.height();
        super.init();
    }

    public void onClose() {
        this.widget.discard();
        super.onClose();
    }

    protected void containerTick() {
        this.widget.update();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ItemStack cursorStack;
        this.widgetRenderContext.update(guiGraphics, partialTicks);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY, 0.0f);
        RenderSystem.disableDepthTest();
        this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        this.widget.renderBackground(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
                ScreenUtils.bindTexture(SLOT_TEXTURE);
                ScreenUtils.drawTexture(guiGraphics.pose(), slot.x - 1, slot.y - 1, 18.0f, 18.0f);
            }
        }
        guiGraphics.pose().popPose();
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY, 0.0f);
        this.widget.render(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        this.hoveredSlot = null;
        for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
            if (!slot.isActive()) continue;
            this.renderSlot(guiGraphics, slot);
            if (!this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) continue;
            this.hoveredSlot = slot;
            WidgetContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.x, (int)slot.y, (int)0, (int)this.getSlotColor(0));
        }
        this.widget.renderForeground(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        this.renderTooltip(guiGraphics, offsetMouseX, offsetMouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        ItemStack itemStack = cursorStack = this.draggingItem.isEmpty() ? ((BaseContainer)this.menu).getCarried() : this.draggingItem;
        if (!cursorStack.isEmpty()) {
            int offset = this.draggingItem.isEmpty() ? 8 : 16;
            String s = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                cursorStack = cursorStack.copy();
                cursorStack.setCount(Mth.ceil((float)((float)cursorStack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1) {
                cursorStack = cursorStack.copy();
                cursorStack.setCount(this.quickCraftingRemainder);
                if (cursorStack.isEmpty()) {
                    s = String.valueOf(ChatFormatting.YELLOW) + "0";
                }
            }
            this.renderFloatingItem(guiGraphics, cursorStack, offsetMouseX - 8, offsetMouseY - offset, s);
        }
        if (!this.snapbackItem.isEmpty()) {
            float f = (float)(Util.getMillis() - this.snapbackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.snapbackItem = ItemStack.EMPTY;
            }
            int j2 = this.snapbackEnd.x - this.snapbackStartX;
            int k2 = this.snapbackEnd.y - this.snapbackStartY;
            int j1 = this.snapbackStartX + (int)((float)j2 * f);
            int k1 = this.snapbackStartY + (int)((float)k2 * f);
            this.renderFloatingItem(guiGraphics, this.snapbackItem, j1, k1, null);
        }
        this.widget.renderOverlay(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(this.widgetRenderContext, offsetMouseX, offsetMouseY);
        guiGraphics.pose().popPose();
        RenderSystem.enableDepthTest();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mousePressed((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.height - this.widget.height()) / 2), button, false) || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.height - this.widget.height()) / 2), button, false) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.height - this.widget.height()) / 2), horizontalAmount, false) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.charTyped(character, modifiers);
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    public Component getNarrationMessage() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

