/*
 * Decompiled with CFR 0.152.
 */
package net.patcraft122.mobiletrash.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.patcraft122.mobiletrash.network.TrashcanGUIButtonMessage;
import net.patcraft122.mobiletrash.procedures.InGUIStainerClosedProcedure;
import net.patcraft122.mobiletrash.procedures.InGUIStainerLabelProcedure;
import net.patcraft122.mobiletrash.world.inventory.TrashcanGUIMenu;

public class TrashcanGUIScreen
extends AbstractContainerScreen<TrashcanGUIMenu> {
    private static final HashMap<String, Object> guistate = TrashcanGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    ImageButton imagebutton_open_strainer;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"mobile_trash:textures/screens/trashcan_gui.png");

    public TrashcanGUIScreen(TrashcanGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        if (InGUIStainerClosedProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"mobile_trash:textures/screens/closed_strainer_sprite.png"), this.leftPos + 50, this.topPos + 62, 0.0f, 0.0f, 73, 16, 73, 16);
        }
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, InGUIStainerLabelProcedure.execute((Entity)this.entity), 66, 66, -12829636, false);
        guiGraphics.drawString(this.font, InGUIStainerLabelProcedure.execute((Entity)this.entity), 65, 65, -205, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.mobile_trash.trashcan_gui.label_trashcan_filter"), 29, 8, -12829636, false);
    }

    public void init() {
        super.init();
        this.imagebutton_open_strainer = new ImageButton(this, this.leftPos + 50, this.topPos + 62, 73, 16, new WidgetSprites(ResourceLocation.parse((String)"mobile_trash:textures/screens/open_strainer.png"), ResourceLocation.parse((String)"mobile_trash:textures/screens/open_strainer_h.png")), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrashcanGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TrashcanGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:imagebutton_open_strainer", this.imagebutton_open_strainer);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_open_strainer);
    }
}

