/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tschipp.carryon.common.carry.CarryOnDataManager;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Unique
    private static final ItemStack DUMMY_STACK = new ItemStack((ItemLike)Blocks.COBBLESTONE, 1);
    @Shadow
    public Player player;
    @Shadow
    public int selected;
    @Shadow
    public NonNullList<ItemStack> items;

    @WrapOperation(method={"getFreeSlot()I"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/core/NonNullList;get(I)Ljava/lang/Object;")})
    private Object getFreeSlotEmptyCheck(NonNullList<Object> instance, int slot, Operation<Object> original) {
        if (slot == this.selected && CarryOnDataManager.getCarryData(this.player).isCarrying()) {
            return DUMMY_STACK;
        }
        return original.call(new Object[]{instance, slot});
    }

    @Inject(method={"setPickedItem(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPickBlock(CallbackInfo info) {
        if (CarryOnDataManager.getCarryData(this.player).isCarrying()) {
            info.cancel();
        }
    }

    @Inject(method={"pickSlot(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPickSlot(int slot, CallbackInfo info) {
        if (CarryOnDataManager.getCarryData(this.player).isCarrying()) {
            info.cancel();
        }
    }

    @Inject(method={"swapPaint(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSwapPaint(double direction, CallbackInfo info) {
        if (CarryOnDataManager.getCarryData(this.player).isCarrying()) {
            info.cancel();
        }
    }
}

