/*
 * Decompiled with CFR 0.152.
 */
package com.mcwstairs.kikoz.objects;

import com.mcwstairs.kikoz.objects.BalconyRailing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StairRailing
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty TOGGLE = BooleanProperty.create((String)"toggle");
    public static final EnumProperty<BalconyRailing.RailingStyle> STYLE = EnumProperty.create((String)"style", BalconyRailing.RailingStyle.class);
    public static final VoxelShape N = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)20.0, (double)16.0);
    public static final VoxelShape E = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)20.0, (double)16.0);
    public static final VoxelShape S = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
    public static final VoxelShape W = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)3.0);
    public static final VoxelShape N_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)38.0, (double)16.0);
    public static final VoxelShape E_COLLISION = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)38.0, (double)16.0);
    public static final VoxelShape S_COLLISION = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)38.0, (double)16.0);
    public static final VoxelShape W_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)38.0, (double)3.0);

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        boolean toggle = (Boolean)state.getValue((Property)TOGGLE);
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return toggle ? N : S;
            }
            case SOUTH: {
                return toggle ? S : N;
            }
            case EAST: {
                return toggle ? W : E;
            }
            case WEST: {
                return toggle ? E : W;
            }
        }
        return N;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        boolean toggle = (Boolean)state.getValue((Property)TOGGLE);
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return toggle ? N_COLLISION : S_COLLISION;
            }
            case SOUTH: {
                return toggle ? S_COLLISION : N_COLLISION;
            }
            case EAST: {
                return toggle ? W_COLLISION : E_COLLISION;
            }
            case WEST: {
                return toggle ? E_COLLISION : W_COLLISION;
            }
        }
        return N_COLLISION;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    public StairRailing(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TOGGLE, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STYLE, (Comparable)((Object)BalconyRailing.RailingStyle.CLASSIC)));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TOGGLE, STYLE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState neighborState = level.getBlockState(blockpos.relative(direction.getOpposite()));
        Direction playerFacingDirection = context.getHorizontalDirection().getOpposite();
        double clickX = context.getClickLocation().x - (double)blockpos.getX();
        double clickZ = context.getClickLocation().z - (double)blockpos.getZ();
        boolean toggleValue = true;
        if (neighborState.hasProperty((Property)FACING)) {
            Direction neighborFacingDirection = (Direction)neighborState.getValue((Property)FACING);
            if (neighborFacingDirection == Direction.NORTH) {
                toggleValue = clickX <= 0.5;
            } else if (neighborFacingDirection == Direction.SOUTH) {
                toggleValue = clickX > 0.5;
            } else if (neighborFacingDirection == Direction.WEST) {
                toggleValue = clickZ > 0.5;
            } else if (neighborFacingDirection == Direction.EAST) {
                toggleValue = clickZ <= 0.5;
            }
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)neighborFacingDirection)).setValue((Property)TOGGLE, (Comparable)Boolean.valueOf(toggleValue));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)playerFacingDirection)).setValue((Property)TOGGLE, (Comparable)Boolean.valueOf(true));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(handIn);
        Item item = heldItem.getItem();
        if (item == Items.SHEARS) {
            if (level.isClientSide()) {
                return ItemInteractionResult.SUCCESS;
            }
            BalconyRailing.RailingStyle currentStyle = (BalconyRailing.RailingStyle)((Object)state.getValue(STYLE));
            BalconyRailing.RailingStyle[] styles = BalconyRailing.RailingStyle.values();
            int newIndex = (currentStyle.ordinal() + 1) % styles.length;
            BalconyRailing.RailingStyle newStyle = styles[newIndex];
            BlockState newState = (BlockState)state.setValue(STYLE, (Comparable)((Object)newStyle));
            level.setBlock(pos, newState, 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return true;
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.levelEvent(1029, pos, 0);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

