/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mekanism.api.MekanismAPITags;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.item.MekanismISTER;
import mekanism.generators.client.model.ModelWindGenerator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RenderWindGeneratorItem
extends MekanismISTER {
    public static final RenderWindGeneratorItem RENDERER = new RenderWindGeneratorItem();
    private static final int SPEED = 16;
    private static int lastTicksUpdated = 0;
    private static int angle = 0;
    private ModelWindGenerator windGenerator;

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
        this.windGenerator = new ModelWindGenerator(this.getEntityModels());
    }

    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight) {
        Minecraft minecraft = Minecraft.getInstance();
        boolean tickingNormally = MekanismRenderer.isRunningNormally();
        if (tickingNormally && minecraft.level != null) {
            if (minecraft.level.dimensionTypeRegistration().is(MekanismAPITags.DimensionTypes.NO_WIND)) {
                tickingNormally = false;
            } else {
                int ticks = Minecraft.getInstance().levelRenderer.getTicks();
                if (lastTicksUpdated != ticks) {
                    angle = (angle + 16) % 360;
                    lastTicksUpdated = ticks;
                }
            }
        }
        float renderAngle = angle;
        if (tickingNormally) {
            renderAngle = (renderAngle + 16.0f * MekanismRenderer.getPartialTick()) % 360.0f;
        }
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        matrix.mulPose(Axis.ZP.rotationDegrees(180.0f));
        this.windGenerator.render(matrix, renderer, renderAngle, light, overlayLight, stack.hasFoil());
        matrix.popPose();
    }
}

